#ifndef CUFFTDX_FFT_30_FP32_INV_PTX_HPP
#define CUFFTDX_FFT_30_FP32_INV_PTX_HPP



template<> __forceinline__ __device__ void cufftdx_private_function<216, float, 1>(cufftdx::detail::complex<float> *rmem, unsigned smem){

asm volatile (R"({
.reg .f32 f<743>;
.reg .b64 rd<2>;
add.f32 f121, %76, %124;
add.f32 f122, %60, f121;
add.f32 f123, %92, %108;
add.f32 f124, f123, f122;
add.f32 f125, %77, %125;
add.f32 f126, %61, f125;
add.f32 f127, %93, %109;
add.f32 f128, f127, f126;
fma.rn.f32 f129, f121, 0f3E9E377A, %60;
mul.f32 f130, f123, 0f3F4F1BBD;
sub.f32 f131, f129, f130;
sub.f32 f132, %77, %125;
mul.f32 f133, f132, 0f3F737871;
sub.f32 f134, %93, %109;
fma.rn.f32 f135, f134, 0f3F167918, f133;
sub.f32 f136, f131, f135;
add.f32 f137, f135, f131;
mul.f32 f138, f121, 0f3F4F1BBD;
sub.f32 f139, %60, f138;
fma.rn.f32 f140, f123, 0f3E9E377A, f139;
mul.f32 f141, f132, 0f3F167918;
mul.f32 f142, f134, 0f3F737871;
sub.f32 f143, f141, f142;
sub.f32 f144, f140, f143;
add.f32 f145, f143, f140;
fma.rn.f32 f146, f125, 0f3E9E377A, %61;
mul.f32 f147, f127, 0f3F4F1BBD;
sub.f32 f148, f146, f147;
sub.f32 f149, %76, %124;
mul.f32 f150, f149, 0f3F737871;
sub.f32 f151, %92, %108;
fma.rn.f32 f152, f151, 0f3F167918, f150;
add.f32 f153, f152, f148;
sub.f32 f154, f148, f152;
mul.f32 f155, f125, 0f3F4F1BBD;
sub.f32 f156, %61, f155;
fma.rn.f32 f157, f127, 0f3E9E377A, f156;
mul.f32 f158, f149, 0f3F167918;
mul.f32 f159, f151, 0f3F737871;
sub.f32 f160, f158, f159;
add.f32 f161, f160, f157;
sub.f32 f162, f157, f160;
add.f32 f163, %81, %129;
add.f32 f164, %65, f163;
add.f32 f165, %97, %113;
add.f32 f166, f165, f164;
add.f32 f167, %83, %131;
add.f32 f168, %67, f167;
add.f32 f169, %99, %115;
add.f32 f170, f169, f168;
fma.rn.f32 f171, f163, 0f3E9E377A, %65;
mul.f32 f172, f165, 0f3F4F1BBD;
sub.f32 f173, f171, f172;
sub.f32 f174, %83, %131;
mul.f32 f175, f174, 0f3F737871;
sub.f32 f176, %99, %115;
fma.rn.f32 f177, f176, 0f3F167918, f175;
sub.f32 f178, f173, f177;
add.f32 f179, f177, f173;
mul.f32 f180, f163, 0f3F4F1BBD;
sub.f32 f181, %65, f180;
fma.rn.f32 f182, f165, 0f3E9E377A, f181;
mul.f32 f183, f174, 0f3F167918;
mul.f32 f184, f176, 0f3F737871;
sub.f32 f185, f183, f184;
sub.f32 f186, f182, f185;
add.f32 f187, f185, f182;
fma.rn.f32 f188, f167, 0f3E9E377A, %67;
mul.f32 f189, f169, 0f3F4F1BBD;
sub.f32 f190, f188, f189;
sub.f32 f191, %81, %129;
mul.f32 f192, f191, 0f3F737871;
sub.f32 f193, %97, %113;
fma.rn.f32 f194, f193, 0f3F167918, f192;
add.f32 f195, f194, f190;
sub.f32 f196, f190, f194;
mul.f32 f197, f167, 0f3F4F1BBD;
sub.f32 f198, %67, f197;
fma.rn.f32 f199, f169, 0f3E9E377A, f198;
mul.f32 f200, f191, 0f3F167918;
mul.f32 f201, f193, 0f3F737871;
sub.f32 f202, f200, f201;
add.f32 f203, f202, f199;
sub.f32 f204, f199, f202;
add.f32 f205, %86, %134;
add.f32 f206, %70, f205;
add.f32 f207, %102, %118;
add.f32 f208, f207, f206;
add.f32 f209, %88, %136;
add.f32 f210, %72, f209;
add.f32 f211, %104, %120;
add.f32 f212, f211, f210;
fma.rn.f32 f213, f205, 0f3E9E377A, %70;
mul.f32 f214, f207, 0f3F4F1BBD;
sub.f32 f215, f213, f214;
sub.f32 f216, %88, %136;
mul.f32 f217, f216, 0f3F737871;
sub.f32 f218, %104, %120;
fma.rn.f32 f219, f218, 0f3F167918, f217;
sub.f32 f220, f215, f219;
add.f32 f221, f219, f215;
mul.f32 f222, f205, 0f3F4F1BBD;
sub.f32 f223, %70, f222;
fma.rn.f32 f224, f207, 0f3E9E377A, f223;
mul.f32 f225, f216, 0f3F167918;
mul.f32 f226, f218, 0f3F737871;
sub.f32 f227, f225, f226;
sub.f32 f228, f224, f227;
add.f32 f229, f227, f224;
fma.rn.f32 f230, f209, 0f3E9E377A, %72;
mul.f32 f231, f211, 0f3F4F1BBD;
sub.f32 f232, f230, f231;
sub.f32 f233, %86, %134;
mul.f32 f234, f233, 0f3F737871;
sub.f32 f235, %102, %118;
fma.rn.f32 f236, f235, 0f3F167918, f234;
add.f32 f237, f236, f232;
sub.f32 f238, f232, f236;
mul.f32 f239, f209, 0f3F4F1BBD;
sub.f32 f240, %72, f239;
fma.rn.f32 f241, f211, 0f3E9E377A, f240;
mul.f32 f242, f233, 0f3F167918;
mul.f32 f243, f235, 0f3F737871;
sub.f32 f244, f242, f243;
add.f32 f245, f244, f241;
sub.f32 f246, f241, f244;
mul.f32 f247, f178, 0f3F69DE1D;
mul.f32 f248, f195, 0f3ED03FC9;
sub.f32 f249, f247, f248;
mul.f32 f250, f195, 0f3F69DE1D;
fma.rn.f32 f251, f178, 0f3ED03FC9, f250;
mul.f32 f252, f220, 0f3F2B4C25;
mul.f32 f253, f237, 0f3F3E3EBD;
sub.f32 f254, f252, f253;
mul.f32 f255, f237, 0f3F2B4C25;
fma.rn.f32 f256, f220, 0f3F3E3EBD, f255;
mul.f32 f257, f186, 0f3F2B4C25;
mul.f32 f258, f203, 0f3F3E3EBD;
sub.f32 f259, f257, f258;
mul.f32 f260, f203, 0f3F2B4C25;
fma.rn.f32 f261, f186, 0f3F3E3EBD, f260;
mul.f32 f262, f228, 0fBDD61305;
mul.f32 f263, f245, 0f3F7E98FD;
sub.f32 f264, f262, f263;
mul.f32 f265, f245, 0fBDD61305;
fma.rn.f32 f266, f228, 0f3F7E98FD, f265;
mul.f32 f267, f187, 0f3E9E377A;
mul.f32 f268, f204, 0f3F737871;
sub.f32 f269, f267, f268;
mul.f32 f270, f204, 0f3E9E377A;
fma.rn.f32 f271, f187, 0f3F737871, f270;
mul.f32 f272, f229, 0fBF4F1BBD;
mul.f32 f273, f246, 0f3F167918;
sub.f32 f274, f272, f273;
mul.f32 f275, f246, 0fBF4F1BBD;
fma.rn.f32 f276, f229, 0f3F167918, f275;
mul.f32 f277, f179, 0fBDD61305;
mul.f32 f278, f196, 0f3F7E98FD;
sub.f32 f279, f277, f278;
mul.f32 f280, f196, 0fBDD61305;
fma.rn.f32 f281, f179, 0f3F7E98FD, f280;
mul.f32 f282, f221, 0fBF7A67E2;
mul.f32 f283, f238, 0fBE54E6CD;
sub.f32 f284, f282, f283;
mul.f32 f285, f238, 0fBF7A67E2;
fma.rn.f32 f286, f221, 0fBE54E6CD, f285;
add.f32 f287, f166, f208;
add.f32 f288, f124, f287;
add.f32 f289, f170, f212;
add.f32 f290, f128, f289;
mul.f32 f291, f287, 0f3F000000;
sub.f32 f292, f124, f291;
sub.f32 f293, f170, f212;
mul.f32 f294, f293, 0fBF5DB3D7;
add.f32 f295, f294, f292;
sub.f32 f296, f292, f294;
mul.f32 f297, f289, 0f3F000000;
sub.f32 f298, f128, f297;
sub.f32 f299, f166, f208;
mul.f32 f300, f299, 0fBF5DB3D7;
sub.f32 f301, f298, f300;
add.f32 f302, f300, f298;
add.f32 f303, f249, f254;
add.f32 f304, f136, f303;
add.f32 f305, f251, f256;
add.f32 f306, f153, f305;
mul.f32 f307, f303, 0f3F000000;
sub.f32 f308, f136, f307;
sub.f32 f309, f251, f256;
mul.f32 f310, f309, 0fBF5DB3D7;
add.f32 f311, f310, f308;
sub.f32 f312, f308, f310;
mul.f32 f313, f305, 0f3F000000;
sub.f32 f314, f153, f313;
sub.f32 f315, f249, f254;
mul.f32 f316, f315, 0fBF5DB3D7;
sub.f32 f317, f314, f316;
add.f32 f318, f316, f314;
add.f32 f319, f259, f264;
add.f32 f320, f144, f319;
add.f32 f321, f261, f266;
add.f32 f322, f161, f321;
mul.f32 f323, f319, 0f3F000000;
sub.f32 f324, f144, f323;
sub.f32 f325, f261, f266;
mul.f32 f326, f325, 0fBF5DB3D7;
add.f32 f327, f326, f324;
sub.f32 f328, f324, f326;
mul.f32 f329, f321, 0f3F000000;
sub.f32 f330, f161, f329;
sub.f32 f331, f259, f264;
mul.f32 f332, f331, 0fBF5DB3D7;
sub.f32 f333, f330, f332;
add.f32 f334, f332, f330;
add.f32 f335, f269, f274;
add.f32 f336, f145, f335;
add.f32 f337, f271, f276;
add.f32 f338, f162, f337;
mul.f32 f339, f335, 0f3F000000;
sub.f32 f340, f145, f339;
sub.f32 f341, f271, f276;
mul.f32 f342, f341, 0fBF5DB3D7;
add.f32 f343, f342, f340;
sub.f32 f344, f340, f342;
mul.f32 f345, f337, 0f3F000000;
sub.f32 f346, f162, f345;
sub.f32 f347, f269, f274;
mul.f32 f348, f347, 0fBF5DB3D7;
sub.f32 f349, f346, f348;
add.f32 f350, f348, f346;
add.f32 f351, f279, f284;
add.f32 f352, f137, f351;
add.f32 f353, f281, f286;
add.f32 f354, f154, f353;
mul.f32 f355, f351, 0f3F000000;
sub.f32 f356, f137, f355;
sub.f32 f357, f281, f286;
mul.f32 f358, f357, 0fBF5DB3D7;
add.f32 f359, f358, f356;
sub.f32 f360, f356, f358;
mul.f32 f361, f353, 0f3F000000;
sub.f32 f362, f154, f361;
sub.f32 f363, f279, f284;
mul.f32 f364, f363, 0fBF5DB3D7;
sub.f32 f365, f362, f364;
add.f32 f366, f364, f362;
add.f32 f367, %78, %126;
add.f32 f368, %62, f367;
add.f32 f369, %94, %110;
add.f32 f370, f369, f368;
add.f32 f371, %80, %128;
add.f32 f372, %64, f371;
add.f32 f373, %96, %112;
add.f32 f374, f373, f372;
fma.rn.f32 f375, f367, 0f3E9E377A, %62;
mul.f32 f376, f369, 0f3F4F1BBD;
sub.f32 f377, f375, f376;
sub.f32 f378, %80, %128;
mul.f32 f379, f378, 0f3F737871;
sub.f32 f380, %96, %112;
fma.rn.f32 f381, f380, 0f3F167918, f379;
sub.f32 f382, f377, f381;
add.f32 f383, f381, f377;
mul.f32 f384, f367, 0f3F4F1BBD;
sub.f32 f385, %62, f384;
fma.rn.f32 f386, f369, 0f3E9E377A, f385;
mul.f32 f387, f378, 0f3F167918;
mul.f32 f388, f380, 0f3F737871;
sub.f32 f389, f387, f388;
sub.f32 f390, f386, f389;
add.f32 f391, f389, f386;
fma.rn.f32 f392, f371, 0f3E9E377A, %64;
mul.f32 f393, f373, 0f3F4F1BBD;
sub.f32 f394, f392, f393;
sub.f32 f395, %78, %126;
mul.f32 f396, f395, 0f3F737871;
sub.f32 f397, %94, %110;
fma.rn.f32 f398, f397, 0f3F167918, f396;
add.f32 f399, f398, f394;
sub.f32 f400, f394, f398;
mul.f32 f401, f371, 0f3F4F1BBD;
sub.f32 f402, %64, f401;
fma.rn.f32 f403, f373, 0f3E9E377A, f402;
mul.f32 f404, f395, 0f3F167918;
mul.f32 f405, f397, 0f3F737871;
sub.f32 f406, f404, f405;
add.f32 f407, f406, f403;
sub.f32 f408, f403, f406;
add.f32 f409, %84, %132;
add.f32 f410, %68, f409;
add.f32 f411, %100, %116;
add.f32 f412, f411, f410;
add.f32 f413, %85, %133;
add.f32 f414, %69, f413;
add.f32 f415, %101, %117;
add.f32 f416, f415, f414;
fma.rn.f32 f417, f409, 0f3E9E377A, %68;
mul.f32 f418, f411, 0f3F4F1BBD;
sub.f32 f419, f417, f418;
sub.f32 f420, %85, %133;
mul.f32 f421, f420, 0f3F737871;
sub.f32 f422, %101, %117;
fma.rn.f32 f423, f422, 0f3F167918, f421;
sub.f32 f424, f419, f423;
add.f32 f425, f423, f419;
mul.f32 f426, f409, 0f3F4F1BBD;
sub.f32 f427, %68, f426;
fma.rn.f32 f428, f411, 0f3E9E377A, f427;
mul.f32 f429, f420, 0f3F167918;
mul.f32 f430, f422, 0f3F737871;
sub.f32 f431, f429, f430;
sub.f32 f432, f428, f431;
add.f32 f433, f431, f428;
fma.rn.f32 f434, f413, 0f3E9E377A, %69;
mul.f32 f435, f415, 0f3F4F1BBD;
sub.f32 f436, f434, f435;
sub.f32 f437, %84, %132;
mul.f32 f438, f437, 0f3F737871;
sub.f32 f439, %100, %116;
fma.rn.f32 f440, f439, 0f3F167918, f438;
add.f32 f441, f440, f436;
sub.f32 f442, f436, f440;
mul.f32 f443, f413, 0f3F4F1BBD;
sub.f32 f444, %69, f443;
fma.rn.f32 f445, f415, 0f3E9E377A, f444;
mul.f32 f446, f437, 0f3F167918;
mul.f32 f447, f439, 0f3F737871;
sub.f32 f448, f446, f447;
add.f32 f449, f448, f445;
sub.f32 f450, f445, f448;
add.f32 f451, %89, %137;
add.f32 f452, %73, f451;
add.f32 f453, %105, %121;
add.f32 f454, f453, f452;
add.f32 f455, %91, %138;
add.f32 f456, %75, f455;
add.f32 f457, %107, %123;
add.f32 f458, f457, f456;
fma.rn.f32 f459, f451, 0f3E9E377A, %73;
mul.f32 f460, f453, 0f3F4F1BBD;
sub.f32 f461, f459, f460;
sub.f32 f462, %91, %138;
mul.f32 f463, f462, 0f3F737871;
sub.f32 f464, %107, %123;
fma.rn.f32 f465, f464, 0f3F167918, f463;
sub.f32 f466, f461, f465;
add.f32 f467, f465, f461;
mul.f32 f468, f451, 0f3F4F1BBD;
sub.f32 f469, %73, f468;
fma.rn.f32 f470, f453, 0f3E9E377A, f469;
mul.f32 f471, f462, 0f3F167918;
mul.f32 f472, f464, 0f3F737871;
sub.f32 f473, f471, f472;
sub.f32 f474, f470, f473;
add.f32 f475, f473, f470;
fma.rn.f32 f476, f455, 0f3E9E377A, %75;
mul.f32 f477, f457, 0f3F4F1BBD;
sub.f32 f478, f476, f477;
sub.f32 f479, %89, %137;
mul.f32 f480, f479, 0f3F737871;
sub.f32 f481, %105, %121;
fma.rn.f32 f482, f481, 0f3F167918, f480;
add.f32 f483, f482, f478;
sub.f32 f484, f478, f482;
mul.f32 f485, f455, 0f3F4F1BBD;
sub.f32 f486, %75, f485;
fma.rn.f32 f487, f457, 0f3E9E377A, f486;
mul.f32 f488, f479, 0f3F167918;
mul.f32 f489, f481, 0f3F737871;
sub.f32 f490, f488, f489;
add.f32 f491, f490, f487;
sub.f32 f492, f487, f490;
mul.f32 f493, f424, 0f3F69DE1D;
mul.f32 f494, f441, 0f3ED03FC9;
sub.f32 f495, f493, f494;
mul.f32 f496, f441, 0f3F69DE1D;
fma.rn.f32 f497, f424, 0f3ED03FC9, f496;
mul.f32 f498, f466, 0f3F2B4C25;
mul.f32 f499, f483, 0f3F3E3EBD;
sub.f32 f500, f498, f499;
mul.f32 f501, f483, 0f3F2B4C25;
fma.rn.f32 f502, f466, 0f3F3E3EBD, f501;
mul.f32 f503, f432, 0f3F2B4C25;
mul.f32 f504, f449, 0f3F3E3EBD;
sub.f32 f505, f503, f504;
mul.f32 f506, f449, 0f3F2B4C25;
fma.rn.f32 f507, f432, 0f3F3E3EBD, f506;
mul.f32 f508, f474, 0fBDD61305;
mul.f32 f509, f491, 0f3F7E98FD;
sub.f32 f510, f508, f509;
mul.f32 f511, f491, 0fBDD61305;
fma.rn.f32 f512, f474, 0f3F7E98FD, f511;
mul.f32 f513, f433, 0f3E9E377A;
mul.f32 f514, f450, 0f3F737871;
sub.f32 f515, f513, f514;
mul.f32 f516, f450, 0f3E9E377A;
fma.rn.f32 f517, f433, 0f3F737871, f516;
mul.f32 f518, f475, 0fBF4F1BBD;
mul.f32 f519, f492, 0f3F167918;
sub.f32 f520, f518, f519;
mul.f32 f521, f492, 0fBF4F1BBD;
fma.rn.f32 f522, f475, 0f3F167918, f521;
mul.f32 f523, f425, 0fBDD61305;
mul.f32 f524, f442, 0f3F7E98FD;
sub.f32 f525, f523, f524;
mul.f32 f526, f442, 0fBDD61305;
fma.rn.f32 f527, f425, 0f3F7E98FD, f526;
mul.f32 f528, f467, 0fBF7A67E2;
mul.f32 f529, f484, 0fBE54E6CD;
sub.f32 f530, f528, f529;
mul.f32 f531, f484, 0fBF7A67E2;
fma.rn.f32 f532, f467, 0fBE54E6CD, f531;
add.f32 f533, f412, f454;
add.f32 f534, f370, f533;
add.f32 f535, f416, f458;
add.f32 f536, f374, f535;
mul.f32 f537, f533, 0f3F000000;
sub.f32 f538, f370, f537;
sub.f32 f539, f416, f458;
mul.f32 f540, f539, 0fBF5DB3D7;
add.f32 f541, f540, f538;
sub.f32 f542, f538, f540;
mul.f32 f543, f535, 0f3F000000;
sub.f32 f544, f374, f543;
sub.f32 f545, f412, f454;
mul.f32 f546, f545, 0fBF5DB3D7;
sub.f32 f547, f544, f546;
add.f32 f548, f546, f544;
add.f32 f549, f495, f500;
add.f32 f550, f382, f549;
add.f32 f551, f497, f502;
add.f32 f552, f399, f551;
mul.f32 f553, f549, 0f3F000000;
sub.f32 f554, f382, f553;
sub.f32 f555, f497, f502;
mul.f32 f556, f555, 0fBF5DB3D7;
add.f32 f557, f556, f554;
sub.f32 f558, f554, f556;
mul.f32 f559, f551, 0f3F000000;
sub.f32 f560, f399, f559;
sub.f32 f561, f495, f500;
mul.f32 f562, f561, 0fBF5DB3D7;
sub.f32 f563, f560, f562;
add.f32 f564, f562, f560;
add.f32 f565, f505, f510;
add.f32 f566, f390, f565;
add.f32 f567, f507, f512;
add.f32 f568, f407, f567;
mul.f32 f569, f565, 0f3F000000;
sub.f32 f570, f390, f569;
sub.f32 f571, f507, f512;
mul.f32 f572, f571, 0fBF5DB3D7;
add.f32 f573, f572, f570;
sub.f32 f574, f570, f572;
mul.f32 f575, f567, 0f3F000000;
sub.f32 f576, f407, f575;
sub.f32 f577, f505, f510;
mul.f32 f578, f577, 0fBF5DB3D7;
sub.f32 f579, f576, f578;
add.f32 f580, f578, f576;
add.f32 f581, f515, f520;
add.f32 f582, f391, f581;
add.f32 f583, f517, f522;
add.f32 f584, f408, f583;
mul.f32 f585, f581, 0f3F000000;
sub.f32 f586, f391, f585;
sub.f32 f587, f517, f522;
mul.f32 f588, f587, 0fBF5DB3D7;
add.f32 f589, f588, f586;
sub.f32 f590, f586, f588;
mul.f32 f591, f583, 0f3F000000;
sub.f32 f592, f408, f591;
sub.f32 f593, f515, f520;
mul.f32 f594, f593, 0fBF5DB3D7;
sub.f32 f595, f592, f594;
add.f32 f596, f594, f592;
add.f32 f597, f525, f530;
add.f32 f598, f383, f597;
add.f32 f599, f527, f532;
add.f32 f600, f400, f599;
mul.f32 f601, f597, 0f3F000000;
sub.f32 f602, f383, f601;
sub.f32 f603, f527, f532;
mul.f32 f604, f603, 0fBF5DB3D7;
add.f32 f605, f604, f602;
sub.f32 f606, f602, f604;
mul.f32 f607, f599, 0f3F000000;
sub.f32 f608, f400, f607;
sub.f32 f609, f525, f530;
mul.f32 f610, f609, 0fBF5DB3D7;
sub.f32 f611, f608, f610;
add.f32 f612, f610, f608;
mul.f32 f613, f550, 0f3F7A67E2;
mul.f32 f614, f552, 0f3E54E6CD;
sub.f32 f615, f613, f614;
mul.f32 f616, f552, 0f3F7A67E2;
fma.rn.f32 f617, f550, 0f3E54E6CD, f616;
mul.f32 f618, f566, 0f3F69DE1D;
mul.f32 f619, f568, 0f3ED03FC9;
sub.f32 f620, f618, f619;
mul.f32 f621, f568, 0f3F69DE1D;
fma.rn.f32 f622, f566, 0f3ED03FC9, f621;
mul.f32 f623, f582, 0f3F4F1BBD;
mul.f32 f624, f584, 0f3F167918;
sub.f32 f625, f623, f624;
mul.f32 f626, f584, 0f3F4F1BBD;
fma.rn.f32 f627, f582, 0f3F167918, f626;
mul.f32 f628, f598, 0f3F2B4C25;
mul.f32 f629, f600, 0f3F3E3EBD;
sub.f32 f630, f628, f629;
mul.f32 f631, f600, 0f3F2B4C25;
fma.rn.f32 f632, f598, 0f3F3E3EBD, f631;
mul.f32 f633, f541, 0f3F000000;
mul.f32 f634, f547, 0f3F5DB3D7;
sub.f32 f635, f633, f634;
mul.f32 f636, f547, 0f3F000000;
fma.rn.f32 f637, f541, 0f3F5DB3D7, f636;
mul.f32 f638, f557, 0f3E9E377A;
mul.f32 f639, f563, 0f3F737871;
sub.f32 f640, f638, f639;
mul.f32 f641, f563, 0f3E9E377A;
fma.rn.f32 f642, f557, 0f3F737871, f641;
mul.f32 f643, f573, 0f3DD61305;
mul.f32 f644, f579, 0f3F7E98FD;
sub.f32 f645, f643, f644;
mul.f32 f646, f579, 0f3DD61305;
fma.rn.f32 f647, f573, 0f3F7E98FD, f646;
mul.f32 f648, f589, 0fBDD61305;
mul.f32 f649, f595, 0f3F7E98FD;
sub.f32 f650, f648, f649;
mul.f32 f651, f595, 0fBDD61305;
fma.rn.f32 f652, f589, 0f3F7E98FD, f651;
mul.f32 f653, f605, 0fBE9E377A;
mul.f32 f654, f611, 0f3F737871;
sub.f32 f655, f653, f654;
mul.f32 f656, f611, 0fBE9E377A;
fma.rn.f32 f657, f605, 0f3F737871, f656;
mul.f32 f658, f542, 0fBF000000;
mul.f32 f659, f548, 0f3F5DB3D7;
sub.f32 f660, f658, f659;
mul.f32 f661, f548, 0fBF000000;
fma.rn.f32 f662, f542, 0f3F5DB3D7, f661;
mul.f32 f663, f558, 0fBF2B4C25;
mul.f32 f664, f564, 0f3F3E3EBD;
sub.f32 f665, f663, f664;
mul.f32 f666, f564, 0fBF2B4C25;
fma.rn.f32 f667, f558, 0f3F3E3EBD, f666;
mul.f32 f668, f574, 0fBF4F1BBD;
mul.f32 f669, f580, 0f3F167918;
sub.f32 f670, f668, f669;
mul.f32 f671, f580, 0fBF4F1BBD;
fma.rn.f32 f672, f574, 0f3F167918, f671;
mul.f32 f673, f590, 0fBF69DE1D;
mul.f32 f674, f596, 0f3ED03FC9;
sub.f32 f675, f673, f674;
mul.f32 f676, f596, 0fBF69DE1D;
fma.rn.f32 f677, f590, 0f3ED03FC9, f676;
mul.f32 f678, f606, 0fBF7A67E2;
mul.f32 f679, f612, 0f3E54E6CD;
sub.f32 f680, f678, f679;
mul.f32 f681, f612, 0fBF7A67E2;
fma.rn.f32 f682, f606, 0f3E54E6CD, f681;
add.f32 %1, f290, f536;
add.f32 %0, f288, f534;
add.f32 %3, f306, f617;
add.f32 %2, f304, f615;
add.f32 %5, f322, f622;
add.f32 %4, f320, f620;
add.f32 %7, f338, f627;
add.f32 %6, f336, f625;
add.f32 %9, f354, f632;
add.f32 %8, f352, f630;
add.f32 %11, f301, f637;
add.f32 %10, f295, f635;
add.f32 %13, f317, f642;
add.f32 %12, f311, f640;
add.f32 %15, f333, f647;
add.f32 %14, f327, f645;
add.f32 %17, f349, f652;
add.f32 %16, f343, f650;
add.f32 %19, f365, f657;
add.f32 %18, f359, f655;
add.f32 %21, f302, f662;
add.f32 %20, f296, f660;
add.f32 %23, f318, f667;
add.f32 %22, f312, f665;
add.f32 %25, f334, f672;
add.f32 %24, f328, f670;
add.f32 %27, f350, f677;
add.f32 %26, f344, f675;
add.f32 %29, f366, f682;
add.f32 %28, f360, f680;
sub.f32 %31, f290, f536;
sub.f32 %30, f288, f534;
sub.f32 %33, f306, f617;
sub.f32 %32, f304, f615;
sub.f32 %35, f322, f622;
sub.f32 %34, f320, f620;
sub.f32 %37, f338, f627;
sub.f32 %36, f336, f625;
sub.f32 %39, f354, f632;
sub.f32 %38, f352, f630;
sub.f32 %41, f301, f637;
sub.f32 %40, f295, f635;
sub.f32 %43, f317, f642;
sub.f32 %42, f311, f640;
sub.f32 %45, f333, f647;
sub.f32 %44, f327, f645;
sub.f32 %47, f349, f652;
sub.f32 %46, f343, f650;
sub.f32 %49, f365, f657;
sub.f32 %48, f359, f655;
sub.f32 %51, f302, f662;
sub.f32 %50, f296, f660;
sub.f32 %53, f318, f667;
sub.f32 %52, f312, f665;
sub.f32 %55, f334, f672;
sub.f32 %54, f328, f670;
sub.f32 %57, f350, f677;
sub.f32 %56, f344, f675;
sub.f32 %59, f366, f682;
sub.f32 %58, f360, f680;
})"
     : "=f"(rmem[0].x), "=f"(rmem[0].y), "=f"(rmem[1].x), "=f"(rmem[1].y), "=f"(rmem[2].x), "=f"(rmem[2].y), "=f"(rmem[3].x), "=f"(rmem[3].y), "=f"(rmem[4].x), "=f"(rmem[4].y), "=f"(rmem[5].x), "=f"(rmem[5].y), "=f"(rmem[6].x), "=f"(rmem[6].y), "=f"(rmem[7].x), "=f"(rmem[7].y), "=f"(rmem[8].x), "=f"(rmem[8].y), "=f"(rmem[9].x), "=f"(rmem[9].y), "=f"(rmem[10].x), "=f"(rmem[10].y), "=f"(rmem[11].x), "=f"(rmem[11].y), "=f"(rmem[12].x), "=f"(rmem[12].y), "=f"(rmem[13].x), "=f"(rmem[13].y), "=f"(rmem[14].x), "=f"(rmem[14].y), "=f"(rmem[15].x), "=f"(rmem[15].y), "=f"(rmem[16].x), "=f"(rmem[16].y), "=f"(rmem[17].x), "=f"(rmem[17].y), "=f"(rmem[18].x), "=f"(rmem[18].y), "=f"(rmem[19].x), "=f"(rmem[19].y), "=f"(rmem[20].x), "=f"(rmem[20].y), "=f"(rmem[21].x), "=f"(rmem[21].y), "=f"(rmem[22].x), "=f"(rmem[22].y), "=f"(rmem[23].x), "=f"(rmem[23].y), "=f"(rmem[24].x), "=f"(rmem[24].y), "=f"(rmem[25].x), "=f"(rmem[25].y), "=f"(rmem[26].x), "=f"(rmem[26].y), "=f"(rmem[27].x), "=f"(rmem[27].y), "=f"(rmem[28].x), "=f"(rmem[28].y), "=f"(rmem[29].x), "=f"(rmem[29].y): "f"(rmem[0].x), "f"(rmem[0].y), "f"(rmem[1].x), "f"(rmem[1].y), "f"(rmem[1].y), "f"(rmem[2].x), "f"(rmem[2].y), "f"(rmem[2].y), "f"(rmem[3].x), "f"(rmem[3].y), "f"(rmem[4].x), "f"(rmem[4].y), "f"(rmem[4].y), "f"(rmem[5].x), "f"(rmem[5].y), "f"(rmem[5].y), "f"(rmem[6].x), "f"(rmem[6].y), "f"(rmem[7].x), "f"(rmem[7].y), "f"(rmem[7].y), "f"(rmem[8].x), "f"(rmem[8].y), "f"(rmem[8].y), "f"(rmem[9].x), "f"(rmem[9].y), "f"(rmem[10].x), "f"(rmem[10].y), "f"(rmem[10].y), "f"(rmem[11].x), "f"(rmem[11].y), "f"(rmem[11].y), "f"(rmem[12].x), "f"(rmem[12].y), "f"(rmem[13].x), "f"(rmem[13].y), "f"(rmem[13].y), "f"(rmem[14].x), "f"(rmem[14].y), "f"(rmem[14].y), "f"(rmem[15].x), "f"(rmem[15].y), "f"(rmem[16].x), "f"(rmem[16].y), "f"(rmem[16].y), "f"(rmem[17].x), "f"(rmem[17].y), "f"(rmem[17].y), "f"(rmem[18].x), "f"(rmem[18].y), "f"(rmem[19].x), "f"(rmem[19].y), "f"(rmem[19].y), "f"(rmem[20].x), "f"(rmem[20].y), "f"(rmem[20].y), "f"(rmem[21].x), "f"(rmem[21].y), "f"(rmem[22].x), "f"(rmem[22].y), "f"(rmem[22].y), "f"(rmem[23].x), "f"(rmem[23].y), "f"(rmem[23].y), "f"(rmem[24].x), "f"(rmem[24].y), "f"(rmem[25].x), "f"(rmem[25].y), "f"(rmem[25].y), "f"(rmem[26].x), "f"(rmem[26].y), "f"(rmem[26].y), "f"(rmem[27].x), "f"(rmem[27].y), "f"(rmem[28].x), "f"(rmem[28].y), "f"(rmem[28].y), "f"(rmem[29].x), "f"(rmem[29].y));
};


#endif
